%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CALCULATE RADIUS OF EACH AMINOACID IN THE STRUCTURE
% (Imported from STRIKE calculation)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function r = radius(atoms, aa)

    atoms = cellfun(@(x) char(x(1:2)),atoms,'UniformOutput',false);
    atom_name = cell2mat(atoms);
    r = zeros(length(atoms),1);
    amino_accid = aa;

    r(atom_name(:,1)=='O')=1.4;
    r(atom_name(:,1)=='N' & atom_name(:,2)=='Z')=1.5;
    r(atom_name(:,1)=='N' & atom_name(:,2)~='Z')=1.65;
    %r(atom_name(:,1)=='C' & atom_name(:,2) == '\0')=1.76;
    
    if(ismember(amino_accid,'ARG') || ismember(amino_accid,'ASN') || ismember(amino_accid,'ASP') || ismember(amino_accid,'GLU') || ismember(amino_accid,'GLN') || ismember(amino_accid,'HIS') || ismember(amino_accid,'PHE') || ismember(amino_accid,'TRP') || ismember(amino_accid,'TYR') || ismember(amino_accid,'ASX') || ismember(amino_accid,'GLX'))
        
        r(atom_name(:,1)=='C') = 1.76;
        r(atom_name(:,1)=='C' & (atom_name(:,2)=='A' | atom_name(:,2)=='B')) = 1.87;
        
        if(ismember(amino_accid,'ARG') || ismember(amino_accid,'GLU') || ismember(amino_accid,'GLN'))
            r(atom_name(:,1)=='C' & atom_name(:,2)=='G') = 1.87; 
            
            if(ismember(amino_accid,'ARG'))
                r(atom_name(:,1)=='C' & atom_name(:,2)=='D') = 1.87; 
            end
        end
               
    else
        r(atom_name(:,1)=='C') = 1.87;
    end
    
    r(atom_name(:,1)=='S') = 1.85;
    r(atom_name(:,1)=='A') = 1.5;
    r(atom_name(:,1)=='E') = 1.9;
    r(atom_name(:,1)=='H') = 1.0;       